/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class GameMidlet
extends MIDlet {
    public static boolean isExpired = false;
    public static byte CLIENT_TYPE = 1;
    public static byte indexClient = 0;
    public static int PORT = 14444;
    public static String IP = "";
    public static byte userProvider = 0;
    public static String clientAgent;
    public static GameMidlet instance;
    public static byte serverLogin;

    public GameMidlet() {
        Session_ME.gI().setHandler(Controller.gI());
        instance = this;
        byte[] mlbData = this.readMlbBytes();
        if (mlbData != null) {
            String decrypted = GameMidlet.decryptCyrilHex(mlbData);
            boolean ok = UpdateServer.loadFromSecureFile(decrypted);
            if (!ok || UpdateServer.isExpired) {
                IP = "0.0.0.0";
                PORT = 0;
                System.out.println("BLOCK: Secret file error or Expired!");
            }
        } else {
            UpdateServer.b();
        }
        clientAgent = this.readFileText("agent.txt");
        userProvider = Byte.parseByte(this.readFileText("provider.txt"));
        SplashScr.splashScrStat = 0;
        GameCanvas.currentScreen = new SplashScr();
        MotherCanvas.gI().tCanvas = GameCanvas.gameAA();
    }

    public byte[] readMlbBytes() {
        try {
            int length;
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/mlb.class");
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] data = baos.toByteArray();
            is.close();
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decryptCyrilHex(byte[] data) {
        try {
            int pipeIdx;
            String reversed;
            if (data == null) {
                return null;
            }
            String hexData = new String(data).trim();
            if (hexData.length() < 6) {
                return null;
            }
            int layers = Integer.parseInt(hexData.substring(0, 2));
            String body = hexData.substring(2);
            int KEY = 302;
            int SALT = 56;
            StringBuffer decryptedChars = new StringBuffer();
            for (int i = 0; i < body.length(); i += 4) {
                int val = Integer.parseInt(body.substring(i, i + 4), 16);
                int idx = i / 4;
                for (int l = layers; l > 0; --l) {
                    val = GameMidlet.transformCyril(val, l, idx, KEY, SALT);
                }
                decryptedChars.append((char)val);
            }
            String temp = decryptedChars.toString();
            StringBuffer sb = new StringBuffer();
            for (int i = temp.length() - 1; i >= 0; --i) {
                sb.append(temp.charAt(i));
            }
            String fullData = reversed = sb.toString();
            if (reversed.length() > 0) {
                fullData = reversed.charAt(reversed.length() - 1) + reversed.substring(0, reversed.length() - 1);
            }
            if ((pipeIdx = fullData.indexOf("|")) != -1) {
                Calendar c;
                long today;
                String expiryStr = fullData.substring(0, pipeIdx);
                String actualData = fullData.substring(pipeIdx + 1);
                if (!expiryStr.equals("00000000") && (today = (long)((c = Calendar.getInstance()).get(1) * 10000 + (c.get(2) + 1) * 100 + c.get(5))) > Long.parseLong(expiryStr)) {
                    isExpired = true;
                    return "ERR_EXPIRED";
                }
                isExpired = false;
                return actualData;
            }
            return fullData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int transformCyril(int val, int layer, int i, int KEY, int SALT) {
        int res = val;
        switch (layer) {
            case 1: {
                res = val ^ KEY + i;
                break;
            }
            case 2: {
                res = val - SALT % (i + 1);
                break;
            }
            case 3: {
                res = val ^ 0xFFFF;
                break;
            }
            case 4: {
                res = val - 5;
                break;
            }
            case 5: {
                res = val ^ 0xAA;
                break;
            }
            case 6: {
                res = val - i % 10;
                break;
            }
            case 7: {
                res = val ^ 0x55;
                break;
            }
            case 8: {
                res = val - 13;
                break;
            }
            case 9: {
                res = val ^ 0xFF;
                break;
            }
            case 10: {
                res = val - KEY % 7;
                break;
            }
            case 11: {
                res = val ^ i + 10;
                break;
            }
            case 12: {
                res = val - 1;
            }
        }
        return res & 0xFFFF;
    }

    protected void destroyApp(boolean var1) {
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        if (UpdateServer.isExpired) {
            this.showExitAlert("TH\u00d4NG B\u00c1O", "Phi\u00ean b\u1ea3n \u0111\u00e3 h\u1ebft h\u1ea1n s\u1eed d\u1ee5ng. Vui l\u00f2ng c\u1eadp nh\u1eadt b\u1ea3n m\u1edbi!");
            return;
        }
        if (IP.equals("0.0.0.0") || IP.equals("")) {
            this.showExitAlert("L\u1ed6I", "D\u1eef li\u1ec7u c\u1ea5u h\u00ecnh kh\u00f4ng h\u1ee3p l\u1ec7!");
            return;
        }
        if (!MotherCanvas.AC) {
            new Thread(MotherCanvas.gI()).start();
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)MotherCanvas.gI());
    }

    private void showExitAlert(String title, String msg) {
        Alert alert = new Alert(title, msg, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GameMidlet.this.notifyDestroyed();
            }
        }).start();
    }

    public static void gameAA(String var0) {
        if (!var0.equals("")) {
            try {
                instance.platformRequest(var0);
                instance.notifyDestroyed();
            }
            catch (ConnectionNotFoundException var1) {
                var1.printStackTrace();
            }
        }
    }

    private String readFileText(String var1) {
        String var3;
        InputStream var5 = ((Object)((Object)this)).getClass().getResourceAsStream("/" + var1);
        try {
            byte[] var4 = new byte[var5.available()];
            var5.read(var4);
            var3 = new String(var4, "UTF-8");
        }
        catch (Exception var2) {
            var3 = "";
        }
        return var3;
    }

    static {
        serverLogin = 0;
    }
}

